<?php
/**
 * Shortcode: Galeri Cover
 * 
 * Cara Menggunakan:
 * [galeri_cover]
 * Media 240601
 * https://example.com/image1.jpg
 * https://example.com/image2.jpg
 * [/galeri_cover]
 */

function galeri_cover_shortcode($atts, $content = null) {
    if (!$content) return '<p style="color:red;">Tidak ada data di dalam shortcode.</p>';
    
    $lines = array_filter(array_map(fn($line) => strip_tags(trim($line)), explode("\n", trim($content))));
    
    do {
        $first_line = strip_tags(trim(array_shift($lines)));
    } while ($first_line === '' || $first_line === null);
    
    if (!preg_match('/^(.+)\s(\d{6})$/', $first_line, $matches)) {
        return '<p style="color:red;">Format judul tidak valid. Baris pertama (asli): <pre>' . htmlspecialchars(json_encode($first_line)) . '</pre></p>';
    }
    
    $media = ucwords(strtolower($matches[1]));
    $tahun = substr($matches[2], 0, 4);
    $bulan = substr($matches[2], 4, 2);
    
    $bulan_nama = [
        '01' => 'Januari', '02' => 'Februari', '03' => 'Maret',
        '04' => 'April', '05' => 'Mei', '06' => 'Juni',
        '07' => 'Juli', '08' => 'Agustus', '09' => 'September',
        '10' => 'Oktober', '11' => 'November', '12' => 'Desember'
    ];
    
    $judul = "<div class='judul-wrapper'><span class='judul-line'></span> Album Cover $media Edisi {$bulan_nama[$bulan]} $tahun <span class='judul-line'></span></div>";
    
    $image_links = array_filter($lines);
    
    function get_indonesian_day($date) {
        $days = [
            'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat', 'Saturday' => 'Sabtu'
        ];
        return $days[date('l', strtotime($date))];
    }

    $sorted_images = [];
    foreach ($image_links as $src) {
        $filename = pathinfo($src, PATHINFO_FILENAME);
        preg_match('/\d{8}/', $filename, $matches);
        
        if (!empty($matches[0])) {
            $date_str = $matches[0];
            $formatted_date = substr($date_str, 0, 4) . '-' . substr($date_str, 4, 2) . '-' . substr($date_str, 6, 2);
            $display_src = preg_replace('/\/s\d+\//', '/s300/', $src);
            
            $sorted_images[$formatted_date] = [
                'original' => $src,
                'display' => $display_src
            ];
        }
    }

    $total_days = cal_days_in_month(CAL_GREGORIAN, $bulan, $tahun);
    $placeholder_url = 'https://arsipkoran.com/img/no-arsip.jpg';
    
    for ($day = 1; $day <= $total_days; $day++) {
        $date_key = sprintf('%04d-%02d-%02d', $tahun, $bulan, $day);
        if (!isset($sorted_images[$date_key])) {
            $sorted_images[$date_key] = [
                'original' => $placeholder_url,
                'display' => $placeholder_url
            ];
        }
    }

    ksort($sorted_images);

    $output = "<div class='judul-container'>$judul</div>";
    $output .= '<div class="cover-koran-wrapper">';
    $output .= '<div class="cover-koran">';

    foreach ($sorted_images as $formatted_date => $image_data) {
        $day_name = get_indonesian_day($formatted_date);
        $caption = $day_name . ' ' . date('d-m-Y', strtotime($formatted_date));

        $output .= '<div class="cover-koran-item">';
        $output .= '<a href="' . esc_url($image_data['original']) . '" target="_blank">';
        $output .= '<img src="' . esc_url($image_data['display']) . '" alt="Cover Koran">';
        $output .= '</a>';
        $output .= '<p>' . esc_html($caption) . '</p>';
        $output .= '</div>';
    }

    $output .= '</div>';
    $output .= '</div>';

    $output .= '<style>
        .judul-container {
            text-align: center;
            margin-top: 70px;
        }
        .judul-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 15px;
            font-size: 1.8em;
            font-weight: bold;
        }
        .judul-line {
            display: inline-block;
            height: 2px;
            background-color: #888;
            min-width: 120px;
            flex-grow: 1;
        }
        .cover-koran-wrapper {
            padding: 10px;
            display: flex;
            justify-content: center;
        }
        .cover-koran {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 10px;
            width: 95%;
            max-width: 1150px;
            padding: 10px;
        }
        .cover-koran-item {
            text-align: center;
            overflow: hidden;
        }
        .cover-koran img {
            width: 100%;
            height: auto;
            object-fit: cover;
            border-radius: 10px;
            transition: transform 0.3s ease, filter 0.3s ease;
            border: 3px solid #ddd;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
        }
        .cover-koran img:hover {
            filter: brightness(80%);
            transform: scale(1.05);
        }
        .cover-koran p {
            margin-top: 5px;
            font-size: 14px;
            color: #333;
        }
        @media (min-width: 1024px) {
            .cover-koran {
                grid-template-columns: repeat(5, 1fr);
            }
        }
    </style>';

    return $output;
}
add_shortcode('galeri_cover', 'galeri_cover_shortcode');
