<?php
function cover_update_harian_textonly_shortcode($atts, $content = null) {
    $content = preg_replace('/<br\s*\/?>/i', "\n", $content);
    $image_links = array_filter(array_map('trim', explode("\n", trim($content))), function($url) {
        return filter_var($url, FILTER_VALIDATE_URL);
    });

    if (empty($image_links)) {
        return '<p>Tidak ada data untuk ditampilkan.</p>';
    }

    function get_indonesian_day($date) {
        $days = [
            'Sunday' => 'Minggu', 'Monday' => 'Senin', 'Tuesday' => 'Selasa',
            'Wednesday' => 'Rabu', 'Thursday' => 'Kamis', 'Friday' => 'Jumat',
            'Saturday' => 'Sabtu'
        ];
        return $days[date('l', strtotime($date))] ?? 'Tidak Diketahui';
    }

    // Urutkan berdasarkan nama file
    usort($image_links, function($a, $b) {
        return strcmp(pathinfo($a, PATHINFO_FILENAME), pathinfo($b, PATHINFO_FILENAME));
    });

    $output = '<div class="cover-update-textonly-wrapper">';
    $output .= '<div class="cover-update-textonly">';

    foreach ($image_links as $index => $src) {
        $filename = pathinfo($src, PATHINFO_FILENAME);
        preg_match('/([a-zA-Z]+)(\d{8})/', $filename, $matches);

        if (!empty($matches[2])) {
            $newspaper_name = strtolower($matches[1]);
            $date_str = $matches[2];
            $formatted_date = substr($date_str, 0, 4) . '-' . substr($date_str, 4, 2) . '-' . substr($date_str, 6, 2);
            $day_name = get_indonesian_day($formatted_date);
            $caption = '<span style="display:block; font-weight:bold;">' . esc_html($newspaper_name) . '</span>' . $day_name . ' ' . substr($formatted_date, 8, 2) . '-' . substr($formatted_date, 5, 2) . '-' . substr($formatted_date, 0, 4);
        } else {
            $caption = 'Tanggal Tidak Diketahui';
        }

        $image_number = str_pad($index + 1, 3, '0', STR_PAD_LEFT);
        $hidden_class = ($index >= 5) ? ' hidden' : '';

        $output .= '<a href="' . esc_url($src) . '" target="_blank" class="cover-update-box' . $hidden_class . '">';
        $output .= '<div class="box-number">' . $image_number . '</div>';
        $output .= '<p>' . $caption . '</p>';
        $output .= '</a>';
    }

    $output .= '</div>';

    if (count($image_links) > 5) {
        $output .= '<button id="loadMoreCovers">TAMPILKAN COVER LAINNYA ...</button>';
    }

    $output .= '</div>';

    $output .= '<style>
        .cover-update-textonly-wrapper {
            padding: 10px;
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        .cover-update-textonly {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 12px;
            width: 100%;
            max-width: 1100px;
            margin: auto;
            padding: 10px;
        }
        .cover-update-box {
            border: 2px solid #ccc;
            border-radius: 10px;
            padding: 10px;
            text-align: center;
            box-shadow: 0 3px 5px rgba(0,0,0,0.1);
            background: #fff;
            text-decoration: none;
            color: inherit;
            transition: transform 0.2s ease;
        }
        .cover-update-box:hover {
            transform: scale(1.03);
            border-color: #007bff;
        }
        .box-number {
            background: black;
            color: white;
            font-weight: bold;
            display: inline-block;
            padding: 6px 10px;
            margin-bottom: 8px;
            border-radius: 4px;
            font-size: 14px;
        }
        .cover-update-box p {
            margin: 0;
            font-size: 14px;
        }
        .hidden { display: none; }
        #loadMoreCovers {
            margin-top: 15px;
            padding: 10px 20px;
            font-size: 20px;
            font-weight: bold;
            cursor: pointer;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            transition: background-color 0.3s;
        }
        #loadMoreCovers:hover {
            background-color: #0056b3;
        }
    </style>';

    $output .= '<script>
        document.addEventListener("DOMContentLoaded", function() {
            let hiddenItems = document.querySelectorAll(".cover-update-box.hidden");
            let loadMoreButton = document.getElementById("loadMoreCovers");
            if (loadMoreButton) {
                loadMoreButton.addEventListener("click", function() {
                    hiddenItems.forEach(item => item.classList.remove("hidden"));
                    loadMoreButton.style.display = "none";
                });
            }
        });
    </script>';

    return $output;
}
add_shortcode('cover_update_harian_textonly', 'cover_update_harian_textonly_shortcode');
