<?php
/**
 * Shortcode untuk membuat tombol beli arsip dengan tampilan menarik.
 *
 * Cara Penggunaan:
 * 1. Dengan atribut URL:
 *    [beli_arsip url="https://contoh.com"]Teks Tombol[/beli_arsip]
 *
 * 2. Dengan format langsung dalam konten:
 *    [beli_arsip]Teks Tombol|https://contoh.com[/beli_arsip]
 *
 * Jika URL tidak diberikan, akan muncul pesan error.
 */

function beli_arsip_shortcode($atts, $content = null) {
    // Ambil URL dari atribut shortcode
    $atts = shortcode_atts(
        array('url' => ''), // Default URL kosong jika tidak diberikan
        $atts,
        'beli_arsip'
    );
    
    // Jika URL tidak diberikan dalam atribut, coba ekstrak dari konten
    if (strpos($content, '|') !== false) {
        list($label, $url) = explode('|', $content, 2);
        $content = trim($label);
        $atts['url'] = trim($url);
    }
    
    // Pastikan URL valid
    $url = esc_url($atts['url']);
    if (empty($url)) {
        return '<p style="color: red; text-align: center;">[Error: URL tidak diberikan]</p>';
    }
    
    // Tambahkan CSS langsung ke dalam output HTML untuk memastikan tampilannya
    $css = '<style>
        .beli-arsip-container {
            text-align: center !important;
            margin-top: 20px !important;
        }
        .beli-arsip-button {
            display: inline-block !important;
            padding: 12px 20px !important;
            font-size: 16px !important;
            font-weight: bold !important;
            text-align: center !important;
            text-decoration: none !important;
            color: #fff !important;
            background: linear-gradient(135deg, #ff7e5f, #feb47b) !important;
            border-radius: 8px !important;
            box-shadow: 0 4px 15px rgba(255, 126, 95, 0.5) !important;
            transition: all 0.3s ease-in-out !important;
            border: none !important;
            cursor: pointer !important;
        }
        .beli-arsip-button:hover {
            box-shadow: 0 0 20px rgba(255, 126, 95, 0.8) !important;
            transform: scale(1.05) !important;
        }
    </style>';
    
    // Kembalikan HTML tombol dengan CSS langsung, di tengah dan open link in new tab
    return $css . '<div class="beli-arsip-container">
        <a href="' . $url . '" class="beli-arsip-button" target="_blank" rel="noopener noreferrer">' . esc_html($content) . '</a>
    </div>';
}
add_shortcode('beli_arsip', 'beli_arsip_shortcode');
