<?php
/**
 * Shortcode [beli_langganan] untuk membuat tombol pembelian langganan.
 * 
 * Penggunaan:
 * 1. Dengan atribut URL:
 *    [beli_langganan url="https://example.com"]Beli Sekarang[/beli_langganan]
 * 
 * 2. Dengan pemisah '|' dalam konten (lebih ringkas):
 *    [beli_langganan]Beli Sekarang | https://example.com[/beli_langganan]
 * 
 * Fungsi ini menghasilkan tombol yang akan mengarahkan pengguna ke URL yang diberikan.
 */

function beli_langganan_shortcode($atts, $content = null) {
    // Ambil URL dari atribut shortcode
    $atts = shortcode_atts(
        array('url' => ''),
        $atts,
        'beli_langganan'
    );
    
    // Cek apakah konten menggunakan format "Label | URL"
    if (strpos($content, '|') !== false) {
        list($label, $url) = explode('|', $content, 2);
        $content = trim($label);
        $atts['url'] = trim($url);
    }
    
    $url = esc_url($atts['url']);
    
    // Jika URL tidak diberikan, tampilkan pesan error
    if (empty($url)) {
        return '<p style="color: red; text-align: center;">[Error: URL tidak diberikan]</p>';
    }
    
    // CSS untuk tombol
    $css = '<style>
        .beli-langganan-container {
            text-align: center !important;
            margin-top: 20px !important;
        }
        .beli-langganan-button {
            display: inline-block !important;
            padding: 12px 20px !important;
            font-size: 16px !important;
            font-weight: bold !important;
            text-align: center !important;
            text-decoration: none !important;
            color: #fff !important;
            background: linear-gradient(135deg, #4CAF50, #2E7D32) !important;
            border-radius: 8px !important;
            box-shadow: 0 4px 15px rgba(76, 175, 80, 0.5) !important;
            transition: all 0.3s ease-in-out !important;
            border: none !important;
            cursor: pointer !important;
        }
        .beli-langganan-button:hover {
            box-shadow: 0 0 20px rgba(76, 175, 80, 0.8) !important;
            transform: scale(1.05) !important;
        }
    </style>';
    
    // Mengembalikan HTML tombol
    return $css . '<div class="beli-langganan-container">
        <a href="' . $url . '" class="beli-langganan-button" target="_blank" rel="noopener noreferrer">' . esc_html($content) . '</a>
    </div>';
}
add_shortcode('beli_langganan', 'beli_langganan_shortcode');
